/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_8.transport;

import org.apache.qpid.server.QpidException;
import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.protocol.v0_8.transport.AMQMethodBody;
import org.apache.qpid.server.protocol.v0_8.transport.AMQMethodBodyImpl;
import org.apache.qpid.server.protocol.v0_8.transport.ClientChannelMethodProcessor;
import org.apache.qpid.server.protocol.v0_8.transport.EncodableAMQDataBlock;
import org.apache.qpid.server.protocol.v0_8.transport.MethodDispatcher;

public class QueueDeleteOkBody
extends AMQMethodBodyImpl
implements EncodableAMQDataBlock,
AMQMethodBody {
    public static final int CLASS_ID = 50;
    public static final int METHOD_ID = 41;
    private final long _messageCount;

    public QueueDeleteOkBody(long messageCount) {
        this._messageCount = messageCount;
    }

    @Override
    public int getClazz() {
        return 50;
    }

    @Override
    public int getMethod() {
        return 41;
    }

    public final long getMessageCount() {
        return this._messageCount;
    }

    @Override
    protected int getBodySize() {
        int size = 4;
        return size;
    }

    @Override
    public void writeMethodPayload(QpidByteBuffer buffer) {
        this.writeUnsignedInteger(buffer, this._messageCount);
    }

    @Override
    public boolean execute(MethodDispatcher dispatcher, int channelId) throws QpidException {
        return dispatcher.dispatchQueueDeleteOk(this, channelId);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder("[QueueDeleteOkBodyImpl: ");
        buf.append("messageCount=");
        buf.append(this.getMessageCount());
        buf.append("]");
        return buf.toString();
    }

    public static void process(QpidByteBuffer buffer, ClientChannelMethodProcessor dispatcher) {
        long messageCount = buffer.getUnsignedInt();
        if (!dispatcher.ignoreAllButCloseOk()) {
            dispatcher.receiveQueueDeleteOk(messageCount);
        }
    }
}

