/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.converter;

import java.lang.reflect.Method;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.support.ObjectHelper;
import org.apache.camel.support.TypeConverterSupport;
import org.apache.camel.util.StringHelper;

public class EnumTypeConverter
extends TypeConverterSupport {
    public <T> T convertTo(Class<T> type, Exchange exchange, Object value) {
        return EnumTypeConverter.doConvertTo(type, exchange, value);
    }

    public static <T> T doConvertTo(Class<T> type, Exchange exchange, Object value) {
        if (type.isEnum()) {
            Method method;
            String text = value.toString();
            Class<T> enumClass = type;
            for (Enum enumValue : (Enum[])enumClass.getEnumConstants()) {
                if (!enumValue.name().equalsIgnoreCase(text)) continue;
                return type.cast(enumValue);
            }
            text = StringHelper.asEnumConstantValue((String)text);
            for (Enum enumValue : (Enum[])enumClass.getEnumConstants()) {
                if (!enumValue.name().equalsIgnoreCase(text)) continue;
                return type.cast(enumValue);
            }
            try {
                method = type.getMethod("valueOf", String.class);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeCamelException("Could not find valueOf method on enum type: " + type.getName());
            }
            return (T)ObjectHelper.invokeMethod((Method)method, null, (Object[])new Object[]{text});
        }
        return null;
    }
}

