/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.header;

import java.util.Optional;
import java.util.function.Supplier;
import org.apache.juneau.assertions.FluentStringAssertion;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.http.header.BasicHeader;

public class BasicStringHeader
extends BasicHeader {
    private static final long serialVersionUID = 1L;
    private final String value;
    private final Supplier<String> supplier;

    public static BasicStringHeader of(String name, String value) {
        return value == null ? null : new BasicStringHeader(name, value);
    }

    public static BasicStringHeader of(String name, Supplier<String> value) {
        return value == null ? null : new BasicStringHeader(name, value);
    }

    public static BasicStringHeader ofPair(String pair) {
        if (pair == null) {
            return null;
        }
        int i = pair.indexOf(58);
        if (i == -1) {
            i = pair.indexOf(61);
        }
        if (i == -1) {
            return BasicStringHeader.of(pair, "");
        }
        return BasicStringHeader.of(pair.substring(0, i).trim(), pair.substring(i + 1).trim());
    }

    public BasicStringHeader(String name, String value) {
        super(name, value);
        this.value = value;
        this.supplier = null;
    }

    public BasicStringHeader(String name, Supplier<String> value) {
        super(name, null);
        this.value = null;
        this.supplier = value;
    }

    public FluentStringAssertion<BasicStringHeader> assertString() {
        return new FluentStringAssertion<BasicStringHeader>(this.value(), this);
    }

    @Override
    public Optional<String> asString() {
        return Utils.opt(this.value());
    }

    @Override
    public String getValue() {
        return Utils.s(this.value());
    }

    @Override
    public String orElse(String other) {
        String x = this.value();
        return Utils.nn(x) ? x : other;
    }

    private String value() {
        if (Utils.nn(this.supplier)) {
            return this.supplier.get();
        }
        return this.value;
    }
}

