/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.message.response;

import com.google.common.collect.ImmutableSet;
import java.util.EnumSet;
import org.apache.james.imap.api.message.response.ImapResponseMessage;
import org.apache.james.imap.api.process.MailboxType;
import org.apache.james.imap.message.response.AbstractListingResponse;
import org.apache.james.mailbox.model.MailboxConstants;
import org.apache.james.mailbox.model.MailboxMetaData;
import org.apache.james.mailbox.model.MailboxPath;

public final class ListResponse
extends AbstractListingResponse
implements ImapResponseMessage {
    private boolean returnSubscribed;
    private boolean returnNonExistent;
    private EnumSet<ChildInfo> childInfos;

    public static Builder builder() {
        return new Builder();
    }

    public ListResponse(MailboxMetaData.Children children, MailboxMetaData.Selectability selectability, String name, char hierarchyDelimiter, boolean returnSubscribed, boolean returnNonExistent, EnumSet<ChildInfo> childInfos, MailboxType mailboxType) {
        super(children, selectability, name, hierarchyDelimiter, mailboxType);
        this.returnSubscribed = returnSubscribed;
        this.returnNonExistent = returnNonExistent;
        this.childInfos = childInfos;
    }

    public boolean isReturnSubscribed() {
        return this.returnSubscribed;
    }

    public boolean isReturnNonExistent() {
        return this.returnNonExistent;
    }

    public EnumSet<ChildInfo> getChildInfos() {
        return this.childInfos;
    }

    @Override
    public String getTypeAsString() {
        return this.getType().getRfc6154attributeName();
    }

    public static class Builder {
        private MailboxMetaData.Children children;
        private MailboxMetaData.Selectability selectability;
        private String name;
        private char hierarchyDelimiter;
        private boolean returnSubscribed;
        private boolean returnNonExistent;
        private MailboxType mailboxType;
        private ImmutableSet.Builder<ChildInfo> childInfos = ImmutableSet.builder();

        public Builder children(MailboxMetaData.Children children) {
            this.children = children;
            return this;
        }

        public Builder selectability(MailboxMetaData.Selectability selectability) {
            this.selectability = selectability;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder hierarchyDelimiter(char hierarchyDelimiter) {
            this.hierarchyDelimiter = hierarchyDelimiter;
            return this;
        }

        public Builder returnSubscribed(boolean returnSubscribed) {
            this.returnSubscribed = returnSubscribed;
            return this;
        }

        public Builder returnNonExistent(boolean returnNonExistent) {
            this.returnNonExistent = returnNonExistent;
            return this;
        }

        public Builder childInfos(ChildInfo ... childInfos) {
            this.childInfos.add((Object[])childInfos);
            return this;
        }

        public Builder mailboxType(MailboxType mailboxType) {
            this.mailboxType = mailboxType;
            return this;
        }

        public Builder forMetaData(MailboxMetaData mailboxMetaData) {
            return this.children(mailboxMetaData.inferiors()).selectability(mailboxMetaData.getSelectability()).hierarchyDelimiter(mailboxMetaData.getHierarchyDelimiter()).returnNonExistent(false);
        }

        public Builder nonExitingSubscribedMailbox(MailboxPath subscribedPath) {
            return this.name(subscribedPath.getName()).children(MailboxMetaData.Children.CHILDREN_ALLOWED_BUT_UNKNOWN).selectability(MailboxMetaData.Selectability.NONE).hierarchyDelimiter(MailboxConstants.FOLDER_DELIMITER).returnSubscribed(true).returnNonExistent(true).mailboxType(MailboxType.OTHER);
        }

        private EnumSet<ChildInfo> buildChildInfos() {
            ImmutableSet childInfoImmutableSet = this.childInfos.build();
            if (childInfoImmutableSet.isEmpty()) {
                return EnumSet.noneOf(ChildInfo.class);
            }
            return EnumSet.copyOf(childInfoImmutableSet);
        }

        public ListResponse build() {
            return new ListResponse(this.children, this.selectability, this.name, this.hierarchyDelimiter, this.returnSubscribed, this.returnNonExistent, this.buildChildInfos(), this.mailboxType);
        }
    }

    public static enum ChildInfo {
        SUBSCRIBED;

    }
}

