/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basecluster.memberlist.agent;

import com.google.protobuf.ByteString;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.subjects.PublishSubject;
import java.net.UnknownHostException;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.bifromq.basecluster.agent.proto.AgentMemberAddr;
import org.apache.bifromq.basecluster.agent.proto.AgentMemberMetadata;
import org.apache.bifromq.basecluster.agent.proto.AgentMessage;
import org.apache.bifromq.basecluster.agent.proto.AgentMessageEnvelope;
import org.apache.bifromq.basecluster.memberlist.agent.CRDTUtil;
import org.apache.bifromq.basecluster.memberlist.agent.IAgentMember;
import org.apache.bifromq.basecluster.memberlist.agent.IAgentMessenger;
import org.apache.bifromq.basecrdt.core.api.CausalCRDTType;
import org.apache.bifromq.basecrdt.core.api.ICRDTOperation;
import org.apache.bifromq.basecrdt.core.api.IORMap;
import org.apache.bifromq.basecrdt.core.api.MVRegOperation;
import org.apache.bifromq.basecrdt.core.api.ORMapOperation;
import org.apache.bifromq.basehlc.HLC;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AgentMember
implements IAgentMember {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AgentMember.class);
    private final AgentMemberAddr localAddr;
    private final IORMap agentCRDT;
    private final IAgentMessenger messenger;
    private final Supplier<Set<AgentMemberAddr>> memberAddresses;
    private final PublishSubject<AgentMessage> agentMessageSubject = PublishSubject.create();
    private final CompositeDisposable disposables = new CompositeDisposable();
    private final ReadWriteLock destroyLock = new ReentrantReadWriteLock();
    private final AtomicReference<AgentMemberMetadata> metadata = new AtomicReference<AgentMemberMetadata>(AgentMemberMetadata.newBuilder().setHlc(HLC.INST.get()).build());
    private volatile boolean destroy = false;

    AgentMember(AgentMemberAddr memberAddr, IORMap agentCRDT, IAgentMessenger messenger, Scheduler scheduler, Supplier<Set<AgentMemberAddr>> memberAddresses) {
        this.localAddr = memberAddr;
        this.agentCRDT = agentCRDT;
        this.messenger = messenger;
        this.memberAddresses = memberAddresses;
        this.updateCRDT();
        this.disposables.add(agentCRDT.inflation().observeOn(scheduler).subscribe(this::updateCRDT));
        this.disposables.add(messenger.receive().filter(msg -> msg.getReceiver().equals(this.localAddr)).map(AgentMessageEnvelope::getMessage).observeOn(scheduler).subscribe(arg_0 -> this.agentMessageSubject.onNext(arg_0)));
    }

    @Override
    public AgentMemberMetadata metadata() {
        return this.metadata.get();
    }

    @Override
    public void metadata(ByteString value) {
        this.skipRunWhenDestroyed(() -> {
            if (!this.metadata.get().getValue().equals((Object)value)) {
                this.metadata.set(AgentMemberMetadata.newBuilder().setValue(value).setHlc(HLC.INST.get()).build());
                this.updateCRDT();
            }
        });
    }

    @Override
    public AgentMemberAddr address() {
        return this.localAddr;
    }

    @Override
    public CompletableFuture<Void> broadcast(ByteString message, boolean reliable) {
        return this.throwsWhenDestroyed(() -> {
            AgentMessage agentMessage = AgentMessage.newBuilder().setSender(this.localAddr).setPayload(message).build();
            return CompletableFuture.allOf((CompletableFuture[])this.memberAddresses.get().stream().map(memberAddr -> this.messenger.send(agentMessage, (AgentMemberAddr)memberAddr, reliable)).toArray(CompletableFuture[]::new)).exceptionally(e -> null);
        });
    }

    @Override
    public CompletableFuture<Void> send(AgentMemberAddr targetMemberAddr, ByteString message, boolean reliable) {
        return this.throwsWhenDestroyed(() -> {
            if (this.memberAddresses.get().contains(targetMemberAddr)) {
                AgentMessage agentMessage = AgentMessage.newBuilder().setSender(this.localAddr).setPayload(message).build();
                return this.messenger.send(agentMessage, targetMemberAddr, reliable);
            }
            return CompletableFuture.failedFuture(new UnknownHostException("Target not found"));
        });
    }

    @Override
    public CompletableFuture<Void> multicast(String targetMemberName, ByteString message, boolean reliable) {
        return this.throwsWhenDestroyed(() -> {
            Set targetAddrs = this.memberAddresses.get().stream().filter(memberAddr -> memberAddr.getName().equals(targetMemberName)).collect(Collectors.toSet());
            AgentMessage agentMessage = AgentMessage.newBuilder().setSender(this.localAddr).setPayload(message).build();
            return CompletableFuture.allOf((CompletableFuture[])targetAddrs.stream().map(targetAddr -> this.messenger.send(agentMessage, (AgentMemberAddr)targetAddr, reliable)).toArray(CompletableFuture[]::new));
        });
    }

    private void updateCRDT(long ts) {
        this.skipRunWhenDestroyed(() -> {
            Optional<AgentMemberMetadata> metaOnCRDT = CRDTUtil.getAgentMemberMetadata(this.agentCRDT, this.localAddr);
            if (metaOnCRDT.isEmpty() || !metaOnCRDT.get().equals(this.metadata.get())) {
                this.updateCRDT();
            }
        });
    }

    private void updateCRDT() {
        this.skipRunWhenDestroyed(() -> this.agentCRDT.execute((ICRDTOperation)ORMapOperation.update((ByteString[])new ByteString[]{this.localAddr.toByteString()}).with(MVRegOperation.write((ByteString)this.metadata.get().toByteString()))));
    }

    @Override
    public Observable<AgentMessage> receive() {
        return this.agentMessageSubject;
    }

    @Override
    public void refresh() {
        this.skipRunWhenDestroyed(() -> {
            this.metadata.set(this.metadata.get().toBuilder().setHlc(HLC.INST.get()).build());
            this.updateCRDT();
        });
    }

    private void skipRunWhenDestroyed(Runnable runnable) {
        Lock readLock = this.destroyLock.readLock();
        try {
            readLock.lock();
            if (this.destroy) {
                return;
            }
            runnable.run();
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<Void> throwsWhenDestroyed(Supplier<CompletableFuture<Void>> callable) {
        Lock readLock = this.destroyLock.readLock();
        try {
            readLock.lock();
            if (this.destroy) {
                throw new IllegalStateException("Agent member has been deregistered");
            }
            CompletableFuture<Void> completableFuture = callable.get();
            return completableFuture;
        }
        finally {
            readLock.unlock();
        }
    }

    CompletableFuture<Void> destroy() {
        Lock writeLock = this.destroyLock.writeLock();
        try {
            writeLock.lock();
            if (this.destroy) {
                CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
                return completableFuture;
            }
            CompletionStage completionStage = this.agentCRDT.execute((ICRDTOperation)ORMapOperation.remove((ByteString[])new ByteString[]{this.localAddr.toByteString()}).of(CausalCRDTType.mvreg)).whenComplete((v, e) -> {
                this.disposables.dispose();
                this.agentMessageSubject.onComplete();
                this.destroy = true;
            });
            return completionStage;
        }
        finally {
            writeLock.unlock();
        }
    }
}

