/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basecluster;

import io.reactivex.rxjava3.core.Observable;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.bifromq.basecluster.AgentHost;
import org.apache.bifromq.basecluster.AgentHostOptions;
import org.apache.bifromq.basecluster.memberlist.HostAddressResolver;
import org.apache.bifromq.basecluster.memberlist.agent.IAgent;
import org.apache.bifromq.basecluster.membership.proto.HostEndpoint;
import org.apache.bifromq.basecluster.transport.TCPTransport;
import org.apache.bifromq.basecluster.transport.Transport;

public interface IAgentHost
extends AutoCloseable {
    public static IAgentHost newInstance(AgentHostOptions options) {
        Transport transport = Transport.builder().env(options.env()).bindAddr(new InetSocketAddress(options.addr(), options.port())).serverSslContext(options.serverSslContext()).clientSslContext(options.clientSslContext()).options(new Transport.TransportOptions().mtu(options.udpPacketLimit()).tcpTransportOptions(new TCPTransport.TCPTransportOptions().maxChannelsPerHost(options.maxChannelsPerHost()).idleTimeoutInSec(options.idleTimeoutInSec()).connTimeoutInMS(options.connTimeoutInMS()))).build();
        HostAddressResolver resolver = new HostAddressResolver(options.addressExpiryInterval(), options.addressRefreshInterval());
        return new AgentHost(transport, resolver, options);
    }

    public String env();

    public HostEndpoint local();

    public CompletableFuture<Void> join(Set<InetSocketAddress> var1);

    public IAgent host(String var1);

    public CompletableFuture<Void> stopHosting(String var1);

    public Observable<Set<HostEndpoint>> membership();

    public Observable<Map<HostEndpoint, Set<String>>> landscape();

    public Observable<Long> refuteSignal();

    @Override
    public void close();
}

