/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.security.thread;

import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.processors.security.IgniteSecurity;
import org.apache.ignite.internal.processors.security.thread.SecurityAwareRunnable;
import org.apache.ignite.internal.util.StripedExecutor;
import org.apache.ignite.internal.util.worker.GridWorkerListener;
import org.apache.ignite.lang.IgniteInClosure;
import org.jetbrains.annotations.NotNull;

public class SecurityAwareStripedExecutor
extends StripedExecutor {
    private final IgniteSecurity security;

    public SecurityAwareStripedExecutor(IgniteSecurity security, int cnt, String igniteInstanceName, String poolName, IgniteLogger log, IgniteInClosure<Throwable> errHnd, GridWorkerListener gridWorkerLsnr, long failureDetectionTimeout) {
        super(cnt, igniteInstanceName, poolName, log, errHnd, gridWorkerLsnr, failureDetectionTimeout);
        this.security = security;
    }

    public SecurityAwareStripedExecutor(IgniteSecurity security, int cnt, String igniteInstanceName, String poolName, IgniteLogger log, IgniteInClosure<Throwable> errHnd, boolean stealTasks, GridWorkerListener gridWorkerLsnr, long failureDetectionTimeout) {
        super(cnt, igniteInstanceName, poolName, log, errHnd, stealTasks, gridWorkerLsnr, failureDetectionTimeout);
        this.security = security;
    }

    @Override
    public void execute(int idx, Runnable cmd) {
        super.execute(idx, SecurityAwareRunnable.of(this.security, cmd));
    }

    @Override
    public void execute(@NotNull Runnable cmd) {
        super.execute(SecurityAwareRunnable.of(this.security, cmd));
    }
}

