/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network;

import java.util.UUID;
import org.apache.ignite.internal.network.InternalClusterNode;
import org.apache.ignite.internal.network.PublicClusterNodeImpl;
import org.apache.ignite.network.ClusterNode;
import org.apache.ignite.network.NetworkAddress;
import org.apache.ignite.network.NodeMetadata;
import org.jetbrains.annotations.Nullable;

public class ClusterNodeImpl
implements InternalClusterNode {
    private final UUID id;
    private final String name;
    private final NetworkAddress address;
    @Nullable
    private final NodeMetadata nodeMetadata;

    public static ClusterNodeImpl fromPublicClusterNode(ClusterNode node) {
        return new ClusterNodeImpl(node.id(), node.name(), node.address(), node.nodeMetadata());
    }

    public ClusterNodeImpl(UUID id, String name, NetworkAddress address, @Nullable NodeMetadata nodeMetadata) {
        this.id = id;
        this.name = name;
        this.address = address;
        this.nodeMetadata = nodeMetadata;
    }

    public ClusterNodeImpl(UUID id, String name, NetworkAddress address) {
        this(id, name, address, null);
    }

    @Override
    public UUID id() {
        return this.id;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public NetworkAddress address() {
        return this.address;
    }

    @Override
    @Nullable
    public NodeMetadata nodeMetadata() {
        return this.nodeMetadata;
    }

    @Override
    public ClusterNode toPublicNode() {
        return new PublicClusterNodeImpl(this.id, this.name, this.address, this.nodeMetadata);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterNodeImpl that = (ClusterNodeImpl)o;
        return this.name.equals(that.name) && this.address.equals((Object)that.address);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.address.hashCode();
        return result;
    }

    public String toString() {
        return String.format("{id=%s, name=%s, address=%s}", this.id, this.name, this.address);
    }
}

