/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.service.invoker;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.KotlinDetector;
import org.springframework.core.MethodParameter;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.ReactiveAdapter;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotationPredicates;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.core.annotation.RepeatableContainers;
import org.springframework.core.annotation.SynthesizingMethodParameter;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.StringValueResolver;
import org.springframework.web.service.annotation.HttpExchange;
import org.springframework.web.service.invoker.HttpExchangeAdapter;
import org.springframework.web.service.invoker.HttpRequestValues;
import org.springframework.web.service.invoker.HttpServiceArgumentResolver;
import org.springframework.web.service.invoker.ReactiveHttpRequestValues;
import org.springframework.web.service.invoker.ReactorHttpExchangeAdapter;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

final class HttpServiceMethod {
    private static final boolean REACTOR_PRESENT = ClassUtils.isPresent("reactor.core.publisher.Mono", HttpServiceMethod.class.getClassLoader());
    private final Method method;
    private final MethodParameter[] parameters;
    private final List<HttpServiceArgumentResolver> argumentResolvers;
    private final HttpRequestValuesInitializer requestValuesInitializer;
    private final ResponseFunction responseFunction;

    HttpServiceMethod(Method method, Class<?> containingClass, List<HttpServiceArgumentResolver> argumentResolvers, HttpExchangeAdapter adapter, @Nullable StringValueResolver embeddedValueResolver) {
        this.method = method;
        this.parameters = HttpServiceMethod.initMethodParameters(method);
        this.argumentResolvers = argumentResolvers;
        boolean isReactorAdapter = REACTOR_PRESENT && adapter instanceof ReactorHttpExchangeAdapter;
        this.requestValuesInitializer = HttpRequestValuesInitializer.create(method, containingClass, embeddedValueResolver, isReactorAdapter ? ReactiveHttpRequestValues::builder : HttpRequestValues::builder);
        this.responseFunction = isReactorAdapter ? ReactorExchangeResponseFunction.create((ReactorHttpExchangeAdapter)adapter, method) : ExchangeResponseFunction.create(adapter, method);
    }

    private static MethodParameter[] initMethodParameters(Method method) {
        int count = method.getParameterCount();
        if (count == 0) {
            return new MethodParameter[0];
        }
        if (KotlinDetector.isSuspendingFunction(method)) {
            --count;
        }
        DefaultParameterNameDiscoverer nameDiscoverer = new DefaultParameterNameDiscoverer();
        MethodParameter[] parameters = new MethodParameter[count];
        for (int i2 = 0; i2 < count; ++i2) {
            parameters[i2] = new SynthesizingMethodParameter(method, i2);
            parameters[i2].initParameterNameDiscovery(nameDiscoverer);
        }
        return parameters;
    }

    public Method getMethod() {
        return this.method;
    }

    @Nullable
    public Object invoke(Object[] arguments) {
        HttpRequestValues.Builder requestValues = this.requestValuesInitializer.initializeRequestValuesBuilder();
        this.applyArguments(requestValues, arguments);
        return this.responseFunction.execute(requestValues.build());
    }

    private void applyArguments(HttpRequestValues.Builder requestValues, Object[] arguments) {
        Assert.isTrue(arguments.length == this.parameters.length, "Method argument mismatch");
        int i2 = 0;
        while (i2 < arguments.length) {
            Object value = arguments[i2];
            boolean resolved = false;
            for (HttpServiceArgumentResolver resolver : this.argumentResolvers) {
                if (!resolver.resolve(value, this.parameters[i2], requestValues)) continue;
                resolved = true;
                break;
            }
            int index2 = i2++;
            Assert.state(resolved, () -> "Could not resolve parameter [" + this.parameters[index2].getParameterIndex() + "] in " + this.parameters[index2].getExecutable().toGenericString() + ": No suitable resolver");
        }
    }

    private record HttpRequestValuesInitializer(@Nullable HttpMethod httpMethod, @Nullable String url, @Nullable MediaType contentType, @Nullable List<MediaType> acceptMediaTypes, MultiValueMap<String, String> headers, Supplier<HttpRequestValues.Builder> requestValuesSupplier) {
        public HttpRequestValues.Builder initializeRequestValuesBuilder() {
            HttpRequestValues.Builder requestValues = this.requestValuesSupplier.get();
            if (this.httpMethod != null) {
                requestValues.setHttpMethod(this.httpMethod);
            }
            if (this.url != null) {
                requestValues.setUriTemplate(this.url);
            }
            if (this.contentType != null) {
                requestValues.setContentType(this.contentType);
            }
            if (this.acceptMediaTypes != null) {
                requestValues.setAccept(this.acceptMediaTypes);
            }
            this.headers.forEach((name, values) -> values.forEach(value -> requestValues.addHeader((String)name, (String)value)));
            return requestValues;
        }

        public static HttpRequestValuesInitializer create(Method method, Class<?> containingClass, @Nullable StringValueResolver embeddedValueResolver, Supplier<HttpRequestValues.Builder> requestValuesSupplier) {
            List<AnnotationDescriptor> methodHttpExchanges = HttpRequestValuesInitializer.getAnnotationDescriptors(method);
            Assert.state(!methodHttpExchanges.isEmpty(), () -> "Expected @HttpExchange annotation on method " + String.valueOf(method));
            Assert.state(methodHttpExchanges.size() == 1, () -> "Multiple @HttpExchange annotations found on method %s, but only one is allowed: %s".formatted(method, methodHttpExchanges));
            List<AnnotationDescriptor> typeHttpExchanges = HttpRequestValuesInitializer.getAnnotationDescriptors(containingClass);
            Assert.state(typeHttpExchanges.size() <= 1, () -> "Multiple @HttpExchange annotations found on %s, but only one is allowed: %s".formatted(containingClass, typeHttpExchanges));
            HttpExchange methodAnnotation = methodHttpExchanges.get((int)0).httpExchange;
            HttpExchange typeAnnotation = !typeHttpExchanges.isEmpty() ? typeHttpExchanges.get((int)0).httpExchange : null;
            HttpMethod httpMethod = HttpRequestValuesInitializer.initHttpMethod(typeAnnotation, methodAnnotation);
            String url = HttpRequestValuesInitializer.initUrl(typeAnnotation, methodAnnotation, embeddedValueResolver);
            MediaType contentType = HttpRequestValuesInitializer.initContentType(typeAnnotation, methodAnnotation);
            List<MediaType> acceptableMediaTypes = HttpRequestValuesInitializer.initAccept(typeAnnotation, methodAnnotation);
            MultiValueMap<String, String> headers = HttpRequestValuesInitializer.initHeaders(typeAnnotation, methodAnnotation, embeddedValueResolver);
            return new HttpRequestValuesInitializer(httpMethod, url, contentType, acceptableMediaTypes, headers, requestValuesSupplier);
        }

        @Nullable
        private static HttpMethod initHttpMethod(@Nullable HttpExchange typeAnnotation, HttpExchange methodAnnotation) {
            String typeLevelMethod;
            String methodLevelMethod = methodAnnotation.method();
            if (StringUtils.hasText(methodLevelMethod)) {
                return HttpMethod.valueOf(methodLevelMethod);
            }
            String string = typeLevelMethod = typeAnnotation != null ? typeAnnotation.method() : null;
            if (StringUtils.hasText(typeLevelMethod)) {
                return HttpMethod.valueOf(typeLevelMethod);
            }
            return null;
        }

        @Nullable
        private static String initUrl(@Nullable HttpExchange typeAnnotation, HttpExchange methodAnnotation, @Nullable StringValueResolver embeddedValueResolver) {
            String typeLevelUrl = typeAnnotation != null ? typeAnnotation.url() : null;
            String methodLevelUrl = methodAnnotation.url();
            if (embeddedValueResolver != null) {
                typeLevelUrl = typeLevelUrl != null ? embeddedValueResolver.resolveStringValue(typeLevelUrl) : null;
                methodLevelUrl = embeddedValueResolver.resolveStringValue(methodLevelUrl);
            }
            boolean hasTypeLevelUrl = StringUtils.hasText(typeLevelUrl);
            boolean hasMethodLevelUrl = StringUtils.hasText(methodLevelUrl);
            if (hasTypeLevelUrl && hasMethodLevelUrl) {
                return typeLevelUrl + (!typeLevelUrl.endsWith("/") && !methodLevelUrl.startsWith("/") ? "/" : "") + methodLevelUrl;
            }
            if (!hasTypeLevelUrl && !hasMethodLevelUrl) {
                return null;
            }
            return hasMethodLevelUrl ? methodLevelUrl : typeLevelUrl;
        }

        @Nullable
        private static MediaType initContentType(@Nullable HttpExchange typeAnnotation, HttpExchange methodAnnotation) {
            String typeLevelContentType;
            String methodLevelContentType = methodAnnotation.contentType();
            if (StringUtils.hasText(methodLevelContentType)) {
                return MediaType.parseMediaType(methodLevelContentType);
            }
            String string = typeLevelContentType = typeAnnotation != null ? typeAnnotation.contentType() : null;
            if (StringUtils.hasText(typeLevelContentType)) {
                return MediaType.parseMediaType(typeLevelContentType);
            }
            return null;
        }

        @Nullable
        private static List<MediaType> initAccept(@Nullable HttpExchange typeAnnotation, HttpExchange methodAnnotation) {
            Object[] typeLevelAccept;
            Object[] methodLevelAccept = methodAnnotation.accept();
            if (!ObjectUtils.isEmpty(methodLevelAccept)) {
                return MediaType.parseMediaTypes(List.of(methodLevelAccept));
            }
            Object[] objectArray = typeLevelAccept = typeAnnotation != null ? typeAnnotation.accept() : null;
            if (!ObjectUtils.isEmpty(typeLevelAccept)) {
                return MediaType.parseMediaTypes(List.of(typeLevelAccept));
            }
            return null;
        }

        private static MultiValueMap<String, String> initHeaders(@Nullable HttpExchange typeAnnotation, HttpExchange methodAnnotation, @Nullable StringValueResolver embeddedValueResolver) {
            LinkedMultiValueMap<String, String> headers = new LinkedMultiValueMap<String, String>();
            if (typeAnnotation != null) {
                HttpRequestValuesInitializer.addHeaders(typeAnnotation.headers(), embeddedValueResolver, headers);
            }
            HttpRequestValuesInitializer.addHeaders(methodAnnotation.headers(), embeddedValueResolver, headers);
            return headers;
        }

        private static void addHeaders(String[] rawValues, @Nullable StringValueResolver embeddedValueResolver, MultiValueMap<String, String> outputHeaders) {
            for (String rawValue : rawValues) {
                String[] pair = StringUtils.split(rawValue, "=");
                if (pair == null) continue;
                String name = pair[0].trim();
                ArrayList<String> values = new ArrayList<String>();
                for (String value : StringUtils.commaDelimitedListToSet(pair[1])) {
                    if (embeddedValueResolver != null) {
                        value = embeddedValueResolver.resolveStringValue(value);
                    }
                    if (value == null) continue;
                    value = value.trim();
                    values.add(value);
                }
                if (values.isEmpty()) continue;
                outputHeaders.addAll(name, values);
            }
        }

        private static List<AnnotationDescriptor> getAnnotationDescriptors(AnnotatedElement element) {
            return MergedAnnotations.from(element, MergedAnnotations.SearchStrategy.TYPE_HIERARCHY, RepeatableContainers.none()).stream(HttpExchange.class).filter(MergedAnnotationPredicates.firstRunOf(MergedAnnotation::getAggregateIndex)).map(AnnotationDescriptor::new).distinct().toList();
        }

        private static class AnnotationDescriptor {
            private final HttpExchange httpExchange;
            private final MergedAnnotation<?> root;

            AnnotationDescriptor(MergedAnnotation<HttpExchange> mergedAnnotation) {
                this.httpExchange = mergedAnnotation.synthesize();
                this.root = mergedAnnotation.getRoot();
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object obj) {
                if (!(obj instanceof AnnotationDescriptor)) return false;
                AnnotationDescriptor that = (AnnotationDescriptor)obj;
                if (!this.httpExchange.equals(that.httpExchange)) return false;
                return true;
            }

            public int hashCode() {
                return this.httpExchange.hashCode();
            }

            public String toString() {
                return this.root.synthesize().toString();
            }
        }
    }

    private record ReactorExchangeResponseFunction(Function<HttpRequestValues, Publisher<?>> responseFunction, @Nullable ReactiveAdapter returnTypeAdapter, boolean blockForOptional, @Nullable Duration blockTimeout) implements ResponseFunction
    {
        private static final String COROUTINES_FLOW_CLASS_NAME = "kotlinx.coroutines.flow.Flow";

        @Override
        @Nullable
        public Object execute(HttpRequestValues requestValues) {
            Publisher<?> responsePublisher = this.responseFunction.apply(requestValues);
            if (this.returnTypeAdapter != null) {
                return this.returnTypeAdapter.fromPublisher(responsePublisher);
            }
            if (this.blockForOptional) {
                return this.blockTimeout != null ? ((Mono)responsePublisher).blockOptional(this.blockTimeout) : ((Mono)responsePublisher).blockOptional();
            }
            return this.blockTimeout != null ? ((Mono)responsePublisher).block(this.blockTimeout) : ((Mono)responsePublisher).block();
        }

        public static ResponseFunction create(ReactorHttpExchangeAdapter client, Method method) {
            Function<HttpRequestValues, Publisher<?>> responseFunction;
            Class<?> actualType;
            ReactiveAdapter reactiveAdapter;
            boolean isUnwrapped;
            MethodParameter returnParam = new MethodParameter(method, -1);
            Class<Object> returnType = returnParam.getParameterType();
            boolean isSuspending = KotlinDetector.isSuspendingFunction(method);
            boolean hasFlowReturnType = COROUTINES_FLOW_CLASS_NAME.equals(returnType.getName());
            boolean bl = isUnwrapped = isSuspending && !hasFlowReturnType;
            if (isSuspending) {
                returnType = hasFlowReturnType ? Flux.class : Mono.class;
            }
            MethodParameter actualParam = (reactiveAdapter = client.getReactiveAdapterRegistry().getAdapter(returnType)) != null ? returnParam.nested() : returnParam.nestedIfOptional();
            Class<?> clazz = actualType = isUnwrapped ? actualParam.getParameterType() : actualParam.getNestedParameterType();
            if (ClassUtils.isVoidType(actualType)) {
                responseFunction = client::exchangeForMono;
            } else if (reactiveAdapter != null && reactiveAdapter.isNoValue()) {
                responseFunction = client::exchangeForMono;
            } else if (actualType.equals(HttpHeaders.class)) {
                responseFunction = client::exchangeForHeadersMono;
            } else if (actualType.equals(ResponseEntity.class)) {
                MethodParameter bodyParam = isUnwrapped ? actualParam : actualParam.nested();
                Class<?> bodyType = bodyParam.getNestedParameterType();
                if (bodyType.equals(Void.class)) {
                    responseFunction = client::exchangeForBodilessEntityMono;
                } else {
                    ReactiveAdapter bodyAdapter = client.getReactiveAdapterRegistry().getAdapter(bodyType);
                    responseFunction = ReactorExchangeResponseFunction.initResponseEntityFunction(client, bodyParam, bodyAdapter, isUnwrapped);
                }
            } else {
                responseFunction = ReactorExchangeResponseFunction.initBodyFunction(client, actualParam, reactiveAdapter, isUnwrapped);
            }
            return new ReactorExchangeResponseFunction(responseFunction, reactiveAdapter, returnType.equals(Optional.class), client.getBlockTimeout());
        }

        private static Function<HttpRequestValues, Publisher<?>> initResponseEntityFunction(ReactorHttpExchangeAdapter client, MethodParameter methodParam, @Nullable ReactiveAdapter reactiveAdapter, boolean isUnwrapped) {
            if (reactiveAdapter == null) {
                return request -> client.exchangeForEntityMono((HttpRequestValues)request, ParameterizedTypeReference.forType(methodParam.getNestedGenericParameterType()));
            }
            Assert.isTrue(reactiveAdapter.isMultiValue(), "ResponseEntity body must be a concrete value or a multi-value Publisher");
            ParameterizedTypeReference bodyType = ParameterizedTypeReference.forType(isUnwrapped ? methodParam.nested().getGenericParameterType() : methodParam.nested().getNestedGenericParameterType());
            if (reactiveAdapter.getReactiveType().equals(Flux.class)) {
                return request -> client.exchangeForEntityFlux((HttpRequestValues)request, bodyType);
            }
            return request -> client.exchangeForEntityFlux((HttpRequestValues)request, bodyType).map(entity -> {
                Flux entityBody = (Flux)entity.getBody();
                Assert.state(entityBody != null, "Entity body must not be null");
                Object body2 = reactiveAdapter.fromPublisher(entityBody);
                return new ResponseEntity<Object>(body2, (MultiValueMap<String, String>)entity.getHeaders(), entity.getStatusCode());
            });
        }

        private static Function<HttpRequestValues, Publisher<?>> initBodyFunction(ReactorHttpExchangeAdapter client, MethodParameter methodParam, @Nullable ReactiveAdapter reactiveAdapter, boolean isSuspending) {
            ParameterizedTypeReference bodyType = ParameterizedTypeReference.forType(isSuspending ? methodParam.getGenericParameterType() : methodParam.getNestedGenericParameterType());
            return reactiveAdapter != null && reactiveAdapter.isMultiValue() ? request -> client.exchangeForBodyFlux((HttpRequestValues)request, bodyType) : request -> client.exchangeForBodyMono((HttpRequestValues)request, bodyType);
        }
    }

    private static interface ResponseFunction {
        @Nullable
        public Object execute(HttpRequestValues var1);
    }

    private record ExchangeResponseFunction(Function<HttpRequestValues, Object> responseFunction) implements ResponseFunction
    {
        @Override
        public Object execute(HttpRequestValues requestValues) {
            return this.responseFunction.apply(requestValues);
        }

        public static ResponseFunction create(HttpExchangeAdapter client, Method method) {
            Function<HttpRequestValues, Object> responseFunction;
            if (KotlinDetector.isSuspendingFunction(method)) {
                throw new IllegalStateException("Kotlin Coroutines are only supported with reactive implementations");
            }
            MethodParameter param = new MethodParameter(method, -1).nestedIfOptional();
            Class<?> paramType = param.getNestedParameterType();
            if (ClassUtils.isVoidType(paramType)) {
                responseFunction = requestValues -> {
                    client.exchange((HttpRequestValues)requestValues);
                    return null;
                };
            } else if (paramType.equals(HttpHeaders.class)) {
                responseFunction = request -> ExchangeResponseFunction.asOptionalIfNecessary(client.exchangeForHeaders((HttpRequestValues)request), param);
            } else if (paramType.equals(ResponseEntity.class)) {
                MethodParameter bodyParam = param.nested();
                if (bodyParam.getNestedParameterType().equals(Void.class)) {
                    responseFunction = request -> ExchangeResponseFunction.asOptionalIfNecessary(client.exchangeForBodilessEntity((HttpRequestValues)request), param);
                } else {
                    ParameterizedTypeReference bodyTypeRef = ParameterizedTypeReference.forType(bodyParam.getNestedGenericParameterType());
                    responseFunction = request -> ExchangeResponseFunction.asOptionalIfNecessary(client.exchangeForEntity((HttpRequestValues)request, bodyTypeRef), param);
                }
            } else {
                ParameterizedTypeReference bodyTypeRef = ParameterizedTypeReference.forType(param.getNestedGenericParameterType());
                responseFunction = request -> ExchangeResponseFunction.asOptionalIfNecessary(client.exchangeForBody((HttpRequestValues)request, bodyTypeRef), param);
            }
            return new ExchangeResponseFunction(responseFunction);
        }

        @Nullable
        private static Object asOptionalIfNecessary(@Nullable Object response, MethodParameter param) {
            return param.getParameterType().equals(Optional.class) ? Optional.ofNullable(response) : response;
        }
    }
}

