/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.codec.support;

import com.google.protobuf.Message;
import io.netty.buffer.ByteBuf;
import io.netty5.buffer.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.springframework.core.codec.AbstractDataBufferDecoder;
import org.springframework.core.codec.ByteArrayDecoder;
import org.springframework.core.codec.ByteArrayEncoder;
import org.springframework.core.codec.ByteBufferDecoder;
import org.springframework.core.codec.ByteBufferEncoder;
import org.springframework.core.codec.CharSequenceEncoder;
import org.springframework.core.codec.DataBufferDecoder;
import org.springframework.core.codec.DataBufferEncoder;
import org.springframework.core.codec.Decoder;
import org.springframework.core.codec.Encoder;
import org.springframework.core.codec.Netty5BufferDecoder;
import org.springframework.core.codec.Netty5BufferEncoder;
import org.springframework.core.codec.NettyByteBufDecoder;
import org.springframework.core.codec.NettyByteBufEncoder;
import org.springframework.core.codec.ResourceDecoder;
import org.springframework.core.codec.StringDecoder;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.codec.CodecConfigurer;
import org.springframework.http.codec.DecoderHttpMessageReader;
import org.springframework.http.codec.EncoderHttpMessageWriter;
import org.springframework.http.codec.FormHttpMessageReader;
import org.springframework.http.codec.FormHttpMessageWriter;
import org.springframework.http.codec.HttpMessageReader;
import org.springframework.http.codec.HttpMessageWriter;
import org.springframework.http.codec.ResourceHttpMessageReader;
import org.springframework.http.codec.ResourceHttpMessageWriter;
import org.springframework.http.codec.ServerSentEventHttpMessageReader;
import org.springframework.http.codec.ServerSentEventHttpMessageWriter;
import org.springframework.http.codec.cbor.KotlinSerializationCborDecoder;
import org.springframework.http.codec.cbor.KotlinSerializationCborEncoder;
import org.springframework.http.codec.json.AbstractJackson2Decoder;
import org.springframework.http.codec.json.Jackson2JsonDecoder;
import org.springframework.http.codec.json.Jackson2JsonEncoder;
import org.springframework.http.codec.json.Jackson2SmileDecoder;
import org.springframework.http.codec.json.Jackson2SmileEncoder;
import org.springframework.http.codec.json.KotlinSerializationJsonDecoder;
import org.springframework.http.codec.json.KotlinSerializationJsonEncoder;
import org.springframework.http.codec.multipart.DefaultPartHttpMessageReader;
import org.springframework.http.codec.multipart.MultipartHttpMessageReader;
import org.springframework.http.codec.multipart.MultipartHttpMessageWriter;
import org.springframework.http.codec.multipart.PartEventHttpMessageReader;
import org.springframework.http.codec.multipart.PartEventHttpMessageWriter;
import org.springframework.http.codec.multipart.PartHttpMessageWriter;
import org.springframework.http.codec.protobuf.KotlinSerializationProtobufDecoder;
import org.springframework.http.codec.protobuf.KotlinSerializationProtobufEncoder;
import org.springframework.http.codec.protobuf.ProtobufDecoder;
import org.springframework.http.codec.protobuf.ProtobufEncoder;
import org.springframework.http.codec.protobuf.ProtobufHttpMessageWriter;
import org.springframework.http.codec.support.BaseCodecConfigurer;
import org.springframework.http.codec.xml.Jaxb2XmlDecoder;
import org.springframework.http.codec.xml.Jaxb2XmlEncoder;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ObjectUtils;

class BaseDefaultCodecs
implements CodecConfigurer.DefaultCodecs,
CodecConfigurer.DefaultCodecConfig {
    static final boolean jackson2Present;
    private static final boolean jackson2SmilePresent;
    private static final boolean jaxb2Present;
    private static final boolean protobufPresent;
    static final boolean nettyByteBufPresent;
    static final boolean netty5BufferPresent;
    static final boolean kotlinSerializationCborPresent;
    static final boolean kotlinSerializationJsonPresent;
    static final boolean kotlinSerializationProtobufPresent;
    @Nullable
    private Decoder<?> jackson2JsonDecoder;
    @Nullable
    private Encoder<?> jackson2JsonEncoder;
    @Nullable
    private Encoder<?> jackson2SmileEncoder;
    @Nullable
    private Decoder<?> jackson2SmileDecoder;
    @Nullable
    private Decoder<?> protobufDecoder;
    @Nullable
    private Encoder<?> protobufEncoder;
    @Nullable
    private Decoder<?> jaxb2Decoder;
    @Nullable
    private Encoder<?> jaxb2Encoder;
    @Nullable
    private Decoder<?> kotlinSerializationCborDecoder;
    @Nullable
    private Encoder<?> kotlinSerializationCborEncoder;
    @Nullable
    private Decoder<?> kotlinSerializationJsonDecoder;
    @Nullable
    private Encoder<?> kotlinSerializationJsonEncoder;
    @Nullable
    private Decoder<?> kotlinSerializationProtobufDecoder;
    @Nullable
    private Encoder<?> kotlinSerializationProtobufEncoder;
    @Nullable
    private DefaultMultipartCodecs multipartCodecs;
    @Nullable
    private Supplier<List<HttpMessageWriter<?>>> partWritersSupplier;
    @Nullable
    private HttpMessageReader<?> multipartReader;
    @Nullable
    private Consumer<Object> codecConsumer;
    @Nullable
    private Integer maxInMemorySize;
    @Nullable
    private Boolean enableLoggingRequestDetails;
    private boolean registerDefaults = true;
    private final List<HttpMessageReader<?>> typedReaders = new ArrayList();
    private final List<HttpMessageReader<?>> objectReaders = new ArrayList();
    private final List<HttpMessageWriter<?>> typedWriters = new ArrayList();
    private final List<HttpMessageWriter<?>> objectWriters = new ArrayList();

    BaseDefaultCodecs() {
        this.initReaders();
        this.initWriters();
    }

    protected void initReaders() {
        this.initTypedReaders();
        this.initObjectReaders();
    }

    protected void initWriters() {
        this.initTypedWriters();
        this.initObjectWriters();
    }

    protected BaseDefaultCodecs(BaseDefaultCodecs other) {
        this.jackson2JsonDecoder = other.jackson2JsonDecoder;
        this.jackson2JsonEncoder = other.jackson2JsonEncoder;
        this.jackson2SmileDecoder = other.jackson2SmileDecoder;
        this.jackson2SmileEncoder = other.jackson2SmileEncoder;
        this.protobufDecoder = other.protobufDecoder;
        this.protobufEncoder = other.protobufEncoder;
        this.jaxb2Decoder = other.jaxb2Decoder;
        this.jaxb2Encoder = other.jaxb2Encoder;
        this.kotlinSerializationCborDecoder = other.kotlinSerializationCborDecoder;
        this.kotlinSerializationCborEncoder = other.kotlinSerializationCborEncoder;
        this.kotlinSerializationJsonDecoder = other.kotlinSerializationJsonDecoder;
        this.kotlinSerializationJsonEncoder = other.kotlinSerializationJsonEncoder;
        this.kotlinSerializationProtobufDecoder = other.kotlinSerializationProtobufDecoder;
        this.kotlinSerializationProtobufEncoder = other.kotlinSerializationProtobufEncoder;
        this.multipartCodecs = other.multipartCodecs != null ? new DefaultMultipartCodecs(other.multipartCodecs) : null;
        this.multipartReader = other.multipartReader;
        this.codecConsumer = other.codecConsumer;
        this.maxInMemorySize = other.maxInMemorySize;
        this.enableLoggingRequestDetails = other.enableLoggingRequestDetails;
        this.registerDefaults = other.registerDefaults;
        this.typedReaders.addAll(other.typedReaders);
        this.objectReaders.addAll(other.objectReaders);
        this.typedWriters.addAll(other.typedWriters);
        this.objectWriters.addAll(other.objectWriters);
    }

    @Override
    public void jackson2JsonDecoder(Decoder<?> decoder) {
        this.jackson2JsonDecoder = decoder;
        this.initObjectReaders();
    }

    @Override
    public void jackson2JsonEncoder(Encoder<?> encoder) {
        this.jackson2JsonEncoder = encoder;
        this.initObjectWriters();
        this.initTypedWriters();
    }

    @Override
    public void jackson2SmileDecoder(Decoder<?> decoder) {
        this.jackson2SmileDecoder = decoder;
        this.initObjectReaders();
    }

    @Override
    public void jackson2SmileEncoder(Encoder<?> encoder) {
        this.jackson2SmileEncoder = encoder;
        this.initObjectWriters();
        this.initTypedWriters();
    }

    @Override
    public void protobufDecoder(Decoder<?> decoder) {
        this.protobufDecoder = decoder;
        this.initTypedReaders();
    }

    @Override
    public void protobufEncoder(Encoder<?> encoder) {
        this.protobufEncoder = encoder;
        this.initTypedWriters();
    }

    @Override
    public void jaxb2Decoder(Decoder<?> decoder) {
        this.jaxb2Decoder = decoder;
        this.initObjectReaders();
    }

    @Override
    public void jaxb2Encoder(Encoder<?> encoder) {
        this.jaxb2Encoder = encoder;
        this.initObjectWriters();
    }

    @Override
    public void kotlinSerializationCborDecoder(Decoder<?> decoder) {
        this.kotlinSerializationCborDecoder = decoder;
        this.initObjectReaders();
    }

    @Override
    public void kotlinSerializationCborEncoder(Encoder<?> encoder) {
        this.kotlinSerializationCborEncoder = encoder;
        this.initObjectWriters();
    }

    @Override
    public void kotlinSerializationJsonDecoder(Decoder<?> decoder) {
        this.kotlinSerializationJsonDecoder = decoder;
        this.initObjectReaders();
    }

    @Override
    public void kotlinSerializationJsonEncoder(Encoder<?> encoder) {
        this.kotlinSerializationJsonEncoder = encoder;
        this.initObjectWriters();
    }

    @Override
    public void kotlinSerializationProtobufDecoder(Decoder<?> decoder) {
        this.kotlinSerializationProtobufDecoder = decoder;
        this.initObjectReaders();
    }

    @Override
    public void kotlinSerializationProtobufEncoder(Encoder<?> encoder) {
        this.kotlinSerializationProtobufEncoder = encoder;
        this.initObjectWriters();
    }

    @Override
    public void configureDefaultCodec(Consumer<Object> codecConsumer) {
        this.codecConsumer = this.codecConsumer != null ? this.codecConsumer.andThen(codecConsumer) : codecConsumer;
        this.initReaders();
        this.initWriters();
    }

    @Override
    public void maxInMemorySize(int byteCount) {
        if (!ObjectUtils.nullSafeEquals(this.maxInMemorySize, byteCount)) {
            this.maxInMemorySize = byteCount;
            this.initReaders();
        }
    }

    @Override
    @Nullable
    public Integer maxInMemorySize() {
        return this.maxInMemorySize;
    }

    @Override
    public void enableLoggingRequestDetails(boolean enable) {
        if (!ObjectUtils.nullSafeEquals(this.enableLoggingRequestDetails, enable)) {
            this.enableLoggingRequestDetails = enable;
            this.initReaders();
            this.initWriters();
        }
    }

    @Override
    public CodecConfigurer.MultipartCodecs multipartCodecs() {
        if (this.multipartCodecs == null) {
            this.multipartCodecs = new DefaultMultipartCodecs();
        }
        return this.multipartCodecs;
    }

    @Override
    public void multipartReader(HttpMessageReader<?> multipartReader) {
        this.multipartReader = multipartReader;
        this.initTypedReaders();
    }

    void setPartWritersSupplier(Supplier<List<HttpMessageWriter<?>>> supplier) {
        this.partWritersSupplier = supplier;
        this.initTypedWriters();
    }

    @Override
    @Nullable
    public Boolean isEnableLoggingRequestDetails() {
        return this.enableLoggingRequestDetails;
    }

    void registerDefaults(boolean registerDefaults) {
        if (this.registerDefaults != registerDefaults) {
            this.registerDefaults = registerDefaults;
            this.initReaders();
            this.initWriters();
        }
    }

    final List<HttpMessageReader<?>> getTypedReaders() {
        return this.typedReaders;
    }

    protected void initTypedReaders() {
        this.typedReaders.clear();
        if (!this.registerDefaults) {
            return;
        }
        this.addCodec(this.typedReaders, new DecoderHttpMessageReader<byte[]>(new ByteArrayDecoder()));
        this.addCodec(this.typedReaders, new DecoderHttpMessageReader<ByteBuffer>(new ByteBufferDecoder()));
        this.addCodec(this.typedReaders, new DecoderHttpMessageReader<DataBuffer>(new DataBufferDecoder()));
        if (nettyByteBufPresent) {
            this.addCodec(this.typedReaders, new DecoderHttpMessageReader<ByteBuf>(new NettyByteBufDecoder()));
        }
        if (netty5BufferPresent) {
            this.addCodec(this.typedReaders, new DecoderHttpMessageReader<Buffer>(new Netty5BufferDecoder()));
        }
        this.addCodec(this.typedReaders, new ResourceHttpMessageReader(new ResourceDecoder()));
        this.addCodec(this.typedReaders, new DecoderHttpMessageReader<String>(StringDecoder.textPlainOnly()));
        if (protobufPresent) {
            this.addCodec(this.typedReaders, new DecoderHttpMessageReader<Message>(this.protobufDecoder != null ? (ProtobufDecoder)this.protobufDecoder : new ProtobufDecoder()));
        } else if (kotlinSerializationProtobufPresent) {
            this.addCodec(this.typedReaders, new DecoderHttpMessageReader<Object>(this.kotlinSerializationProtobufDecoder != null ? (KotlinSerializationProtobufDecoder)this.kotlinSerializationProtobufDecoder : new KotlinSerializationProtobufDecoder()));
        }
        this.addCodec(this.typedReaders, new FormHttpMessageReader());
        if (this.multipartReader != null) {
            this.addCodec(this.typedReaders, this.multipartReader);
        } else {
            DefaultPartHttpMessageReader partReader = new DefaultPartHttpMessageReader();
            this.addCodec(this.typedReaders, partReader);
            this.addCodec(this.typedReaders, new MultipartHttpMessageReader(partReader));
        }
        this.addCodec(this.typedReaders, new PartEventHttpMessageReader());
        this.extendTypedReaders(this.typedReaders);
    }

    protected <T> void addCodec(List<T> codecs, T codec) {
        this.initCodec(codec);
        codecs.add(codec);
    }

    private void initCodec(@Nullable Object codec) {
        MultipartHttpMessageReader multipartHttpMessageReader;
        Boolean enable;
        if (codec instanceof DecoderHttpMessageReader) {
            DecoderHttpMessageReader decoderHttpMessageReader = (DecoderHttpMessageReader)codec;
            codec = decoderHttpMessageReader.getDecoder();
        } else if (codec instanceof EncoderHttpMessageWriter) {
            EncoderHttpMessageWriter encoderHttpMessageWriter = (EncoderHttpMessageWriter)codec;
            codec = encoderHttpMessageWriter.getEncoder();
        }
        if (codec == null) {
            return;
        }
        Integer size = this.maxInMemorySize;
        if (size != null) {
            if (codec instanceof AbstractDataBufferDecoder) {
                AbstractDataBufferDecoder abstractDataBufferDecoder = (AbstractDataBufferDecoder)codec;
                abstractDataBufferDecoder.setMaxInMemorySize(size);
            }
            if (protobufPresent && codec instanceof ProtobufDecoder) {
                ProtobufDecoder protobufDec = (ProtobufDecoder)codec;
                protobufDec.setMaxMessageSize(size);
            }
            if (kotlinSerializationCborPresent && codec instanceof KotlinSerializationCborDecoder) {
                KotlinSerializationCborDecoder kotlinSerializationCborDec = (KotlinSerializationCborDecoder)codec;
                kotlinSerializationCborDec.setMaxInMemorySize(size);
            }
            if (kotlinSerializationJsonPresent && codec instanceof KotlinSerializationJsonDecoder) {
                KotlinSerializationJsonDecoder kotlinSerializationJsonDec = (KotlinSerializationJsonDecoder)codec;
                kotlinSerializationJsonDec.setMaxInMemorySize(size);
            }
            if (kotlinSerializationProtobufPresent && codec instanceof KotlinSerializationProtobufDecoder) {
                KotlinSerializationProtobufDecoder kotlinSerializationProtobufDec = (KotlinSerializationProtobufDecoder)codec;
                kotlinSerializationProtobufDec.setMaxInMemorySize(size);
            }
            if (jackson2Present && codec instanceof AbstractJackson2Decoder) {
                AbstractJackson2Decoder abstractJackson2Decoder = (AbstractJackson2Decoder)codec;
                abstractJackson2Decoder.setMaxInMemorySize(size);
            }
            if (jaxb2Present && codec instanceof Jaxb2XmlDecoder) {
                Jaxb2XmlDecoder jaxb2XmlDecoder = (Jaxb2XmlDecoder)codec;
                jaxb2XmlDecoder.setMaxInMemorySize(size);
            }
            if (codec instanceof FormHttpMessageReader) {
                FormHttpMessageReader formHttpMessageReader = (FormHttpMessageReader)codec;
                formHttpMessageReader.setMaxInMemorySize(size);
            }
            if (codec instanceof ServerSentEventHttpMessageReader) {
                ServerSentEventHttpMessageReader serverSentEventHttpMessageReader = (ServerSentEventHttpMessageReader)codec;
                serverSentEventHttpMessageReader.setMaxInMemorySize(size);
            }
            if (codec instanceof DefaultPartHttpMessageReader) {
                DefaultPartHttpMessageReader defaultPartHttpMessageReader = (DefaultPartHttpMessageReader)codec;
                defaultPartHttpMessageReader.setMaxInMemorySize(size);
            }
            if (codec instanceof PartEventHttpMessageReader) {
                PartEventHttpMessageReader partEventHttpMessageReader = (PartEventHttpMessageReader)codec;
                partEventHttpMessageReader.setMaxInMemorySize(size);
            }
        }
        if ((enable = this.enableLoggingRequestDetails) != null) {
            if (codec instanceof FormHttpMessageReader) {
                FormHttpMessageReader formHttpMessageReader = (FormHttpMessageReader)codec;
                formHttpMessageReader.setEnableLoggingRequestDetails(enable);
            }
            if (codec instanceof MultipartHttpMessageReader) {
                multipartHttpMessageReader = (MultipartHttpMessageReader)codec;
                multipartHttpMessageReader.setEnableLoggingRequestDetails(enable);
            }
            if (codec instanceof DefaultPartHttpMessageReader) {
                DefaultPartHttpMessageReader defaultPartHttpMessageReader = (DefaultPartHttpMessageReader)codec;
                defaultPartHttpMessageReader.setEnableLoggingRequestDetails(enable);
            }
            if (codec instanceof PartEventHttpMessageReader) {
                PartEventHttpMessageReader partEventHttpMessageReader = (PartEventHttpMessageReader)codec;
                partEventHttpMessageReader.setEnableLoggingRequestDetails(enable);
            }
            if (codec instanceof FormHttpMessageWriter) {
                FormHttpMessageWriter formHttpMessageWriter = (FormHttpMessageWriter)codec;
                formHttpMessageWriter.setEnableLoggingRequestDetails(enable);
            }
            if (codec instanceof MultipartHttpMessageWriter) {
                MultipartHttpMessageWriter multipartHttpMessageWriter = (MultipartHttpMessageWriter)codec;
                multipartHttpMessageWriter.setEnableLoggingRequestDetails(enable);
            }
        }
        if (this.codecConsumer != null) {
            this.codecConsumer.accept(codec);
        }
        if (codec instanceof MultipartHttpMessageReader) {
            multipartHttpMessageReader = (MultipartHttpMessageReader)codec;
            this.initCodec(multipartHttpMessageReader.getPartReader());
        } else if (codec instanceof MultipartHttpMessageWriter) {
            MultipartHttpMessageWriter multipartHttpMessageWriter = (MultipartHttpMessageWriter)codec;
            this.initCodec(multipartHttpMessageWriter.getFormWriter());
        } else if (codec instanceof ServerSentEventHttpMessageReader) {
            ServerSentEventHttpMessageReader serverSentEventHttpMessageReader = (ServerSentEventHttpMessageReader)codec;
            this.initCodec(serverSentEventHttpMessageReader.getDecoder());
        } else if (codec instanceof ServerSentEventHttpMessageWriter) {
            ServerSentEventHttpMessageWriter serverSentEventHttpMessageWriter = (ServerSentEventHttpMessageWriter)codec;
            this.initCodec(serverSentEventHttpMessageWriter.getEncoder());
        }
    }

    protected void extendTypedReaders(List<HttpMessageReader<?>> typedReaders) {
    }

    final List<HttpMessageReader<?>> getObjectReaders() {
        return this.objectReaders;
    }

    protected void initObjectReaders() {
        this.objectReaders.clear();
        if (!this.registerDefaults) {
            return;
        }
        if (kotlinSerializationCborPresent) {
            this.addCodec(this.objectReaders, new DecoderHttpMessageReader<Object>(this.kotlinSerializationCborDecoder != null ? (KotlinSerializationCborDecoder)this.kotlinSerializationCborDecoder : new KotlinSerializationCborDecoder()));
        }
        if (kotlinSerializationJsonPresent) {
            this.addCodec(this.objectReaders, new DecoderHttpMessageReader(this.getKotlinSerializationJsonDecoder()));
        }
        if (kotlinSerializationProtobufPresent) {
            this.addCodec(this.objectReaders, new DecoderHttpMessageReader<Object>(this.kotlinSerializationProtobufDecoder != null ? (KotlinSerializationProtobufDecoder)this.kotlinSerializationProtobufDecoder : new KotlinSerializationProtobufDecoder()));
        }
        if (jackson2Present) {
            this.addCodec(this.objectReaders, new DecoderHttpMessageReader(this.getJackson2JsonDecoder()));
        }
        if (jackson2SmilePresent) {
            this.addCodec(this.objectReaders, new DecoderHttpMessageReader<Object>(this.jackson2SmileDecoder != null ? (Jackson2SmileDecoder)this.jackson2SmileDecoder : new Jackson2SmileDecoder()));
        }
        if (jaxb2Present) {
            this.addCodec(this.objectReaders, new DecoderHttpMessageReader<Object>(this.jaxb2Decoder != null ? (Jaxb2XmlDecoder)this.jaxb2Decoder : new Jaxb2XmlDecoder()));
        }
        this.extendObjectReaders(this.objectReaders);
    }

    protected void extendObjectReaders(List<HttpMessageReader<?>> objectReaders) {
    }

    final List<HttpMessageReader<?>> getCatchAllReaders() {
        if (!this.registerDefaults) {
            return Collections.emptyList();
        }
        ArrayList readers = new ArrayList();
        this.addCodec(readers, new DecoderHttpMessageReader<String>(StringDecoder.allMimeTypes()));
        return readers;
    }

    final List<HttpMessageWriter<?>> getTypedWriters() {
        return this.typedWriters;
    }

    protected void initTypedWriters() {
        this.typedWriters.clear();
        if (!this.registerDefaults) {
            return;
        }
        this.typedWriters.addAll(this.getBaseTypedWriters());
        this.extendTypedWriters(this.typedWriters);
    }

    final List<HttpMessageWriter<?>> getBaseTypedWriters() {
        if (!this.registerDefaults) {
            return Collections.emptyList();
        }
        ArrayList writers = new ArrayList();
        this.addCodec(writers, new EncoderHttpMessageWriter<byte[]>(new ByteArrayEncoder()));
        this.addCodec(writers, new EncoderHttpMessageWriter<ByteBuffer>(new ByteBufferEncoder()));
        this.addCodec(writers, new EncoderHttpMessageWriter<DataBuffer>(new DataBufferEncoder()));
        if (nettyByteBufPresent) {
            this.addCodec(writers, new EncoderHttpMessageWriter<ByteBuf>(new NettyByteBufEncoder()));
        }
        if (netty5BufferPresent) {
            this.addCodec(writers, new EncoderHttpMessageWriter<Buffer>(new Netty5BufferEncoder()));
        }
        this.addCodec(writers, new ResourceHttpMessageWriter());
        this.addCodec(writers, new EncoderHttpMessageWriter<CharSequence>(CharSequenceEncoder.textPlainOnly()));
        if (protobufPresent) {
            this.addCodec(writers, new ProtobufHttpMessageWriter(this.protobufEncoder != null ? (ProtobufEncoder)this.protobufEncoder : new ProtobufEncoder()));
        }
        this.addCodec(writers, new MultipartHttpMessageWriter(this::getPartWriters, (HttpMessageWriter<MultiValueMap<String, String>>)new FormHttpMessageWriter()));
        this.addCodec(writers, new PartEventHttpMessageWriter());
        this.addCodec(writers, new PartHttpMessageWriter());
        return writers;
    }

    private List<HttpMessageWriter<?>> getPartWriters() {
        if (this.multipartCodecs != null) {
            return this.multipartCodecs.getWriters();
        }
        if (this.partWritersSupplier != null) {
            return this.partWritersSupplier.get();
        }
        return Collections.emptyList();
    }

    protected void extendTypedWriters(List<HttpMessageWriter<?>> typedWriters) {
    }

    final List<HttpMessageWriter<?>> getObjectWriters() {
        return this.objectWriters;
    }

    protected void initObjectWriters() {
        this.objectWriters.clear();
        if (!this.registerDefaults) {
            return;
        }
        this.objectWriters.addAll(this.getBaseObjectWriters());
        this.extendObjectWriters(this.objectWriters);
    }

    final List<HttpMessageWriter<?>> getBaseObjectWriters() {
        ArrayList writers = new ArrayList();
        if (kotlinSerializationCborPresent) {
            this.addCodec(writers, new EncoderHttpMessageWriter<Object>(this.kotlinSerializationCborEncoder != null ? (KotlinSerializationCborEncoder)this.kotlinSerializationCborEncoder : new KotlinSerializationCborEncoder()));
        }
        if (kotlinSerializationJsonPresent) {
            this.addCodec(writers, new EncoderHttpMessageWriter(this.getKotlinSerializationJsonEncoder()));
        }
        if (kotlinSerializationProtobufPresent) {
            this.addCodec(writers, new EncoderHttpMessageWriter<Object>(this.kotlinSerializationProtobufEncoder != null ? (KotlinSerializationProtobufEncoder)this.kotlinSerializationProtobufEncoder : new KotlinSerializationProtobufEncoder()));
        }
        if (jackson2Present) {
            this.addCodec(writers, new EncoderHttpMessageWriter(this.getJackson2JsonEncoder()));
        }
        if (jackson2SmilePresent) {
            this.addCodec(writers, new EncoderHttpMessageWriter<Object>(this.jackson2SmileEncoder != null ? (Jackson2SmileEncoder)this.jackson2SmileEncoder : new Jackson2SmileEncoder()));
        }
        if (jaxb2Present) {
            this.addCodec(writers, new EncoderHttpMessageWriter<Object>(this.jaxb2Encoder != null ? (Jaxb2XmlEncoder)this.jaxb2Encoder : new Jaxb2XmlEncoder()));
        }
        return writers;
    }

    protected void extendObjectWriters(List<HttpMessageWriter<?>> objectWriters) {
    }

    List<HttpMessageWriter<?>> getCatchAllWriters() {
        if (!this.registerDefaults) {
            return Collections.emptyList();
        }
        ArrayList result = new ArrayList();
        result.add(new EncoderHttpMessageWriter<CharSequence>(CharSequenceEncoder.allMimeTypes()));
        return result;
    }

    void applyDefaultConfig(BaseCodecConfigurer.DefaultCustomCodecs customCodecs) {
        this.applyDefaultConfig(customCodecs.getTypedReaders());
        this.applyDefaultConfig(customCodecs.getObjectReaders());
        this.applyDefaultConfig(customCodecs.getTypedWriters());
        this.applyDefaultConfig(customCodecs.getObjectWriters());
        customCodecs.getDefaultConfigConsumers().forEach(consumer -> consumer.accept(this));
    }

    private void applyDefaultConfig(Map<?, Boolean> readers) {
        readers.entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).forEach(this::initCodec);
    }

    protected Decoder<?> getJackson2JsonDecoder() {
        if (this.jackson2JsonDecoder == null) {
            this.jackson2JsonDecoder = new Jackson2JsonDecoder();
        }
        return this.jackson2JsonDecoder;
    }

    protected Encoder<?> getJackson2JsonEncoder() {
        if (this.jackson2JsonEncoder == null) {
            this.jackson2JsonEncoder = new Jackson2JsonEncoder();
        }
        return this.jackson2JsonEncoder;
    }

    protected Decoder<?> getKotlinSerializationJsonDecoder() {
        if (this.kotlinSerializationJsonDecoder == null) {
            this.kotlinSerializationJsonDecoder = new KotlinSerializationJsonDecoder();
        }
        return this.kotlinSerializationJsonDecoder;
    }

    protected Encoder<?> getKotlinSerializationJsonEncoder() {
        if (this.kotlinSerializationJsonEncoder == null) {
            this.kotlinSerializationJsonEncoder = new KotlinSerializationJsonEncoder();
        }
        return this.kotlinSerializationJsonEncoder;
    }

    static {
        ClassLoader classLoader = BaseCodecConfigurer.class.getClassLoader();
        jackson2Present = ClassUtils.isPresent("com.fasterxml.jackson.databind.ObjectMapper", classLoader) && ClassUtils.isPresent("com.fasterxml.jackson.core.JsonGenerator", classLoader);
        jackson2SmilePresent = ClassUtils.isPresent("com.fasterxml.jackson.dataformat.smile.SmileFactory", classLoader);
        jaxb2Present = ClassUtils.isPresent("jakarta.xml.bind.Binder", classLoader);
        protobufPresent = ClassUtils.isPresent("com.google.protobuf.Message", classLoader);
        nettyByteBufPresent = ClassUtils.isPresent("io.netty.buffer.ByteBuf", classLoader);
        netty5BufferPresent = ClassUtils.isPresent("io.netty5.buffer.Buffer", classLoader);
        kotlinSerializationCborPresent = ClassUtils.isPresent("kotlinx.serialization.cbor.Cbor", classLoader);
        kotlinSerializationJsonPresent = ClassUtils.isPresent("kotlinx.serialization.json.Json", classLoader);
        kotlinSerializationProtobufPresent = ClassUtils.isPresent("kotlinx.serialization.protobuf.ProtoBuf", classLoader);
    }

    protected class DefaultMultipartCodecs
    implements CodecConfigurer.MultipartCodecs {
        private final List<HttpMessageWriter<?>> writers = new ArrayList();

        DefaultMultipartCodecs() {
        }

        DefaultMultipartCodecs(DefaultMultipartCodecs other) {
            this.writers.addAll(other.writers);
        }

        @Override
        public CodecConfigurer.MultipartCodecs encoder(Encoder<?> encoder) {
            this.writer(new EncoderHttpMessageWriter(encoder));
            BaseDefaultCodecs.this.initTypedWriters();
            return this;
        }

        @Override
        public CodecConfigurer.MultipartCodecs writer(HttpMessageWriter<?> writer) {
            this.writers.add(writer);
            BaseDefaultCodecs.this.initTypedWriters();
            return this;
        }

        List<HttpMessageWriter<?>> getWriters() {
            return this.writers;
        }
    }
}

