/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.security.reactive;

import java.util.function.Supplier;
import org.springframework.context.ApplicationContext;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatcher;
import org.springframework.util.Assert;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public abstract class ApplicationContextServerWebExchangeMatcher<C>
implements ServerWebExchangeMatcher {
    private final Class<? extends C> contextClass;
    private volatile Supplier<C> context;
    private final Object contextLock = new Object();

    public ApplicationContextServerWebExchangeMatcher(Class<? extends C> contextClass) {
        Assert.notNull(contextClass, "'contextClass' must not be null");
        this.contextClass = contextClass;
    }

    public final Mono<ServerWebExchangeMatcher.MatchResult> matches(ServerWebExchange exchange2) {
        if (this.ignoreApplicationContext(exchange2.getApplicationContext())) {
            return ServerWebExchangeMatcher.MatchResult.notMatch();
        }
        return this.matches(exchange2, this.getContext(exchange2));
    }

    protected abstract Mono<ServerWebExchangeMatcher.MatchResult> matches(ServerWebExchange var1, Supplier<C> var2);

    protected boolean ignoreApplicationContext(ApplicationContext applicationContext) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Supplier<C> getContext(ServerWebExchange exchange2) {
        if (this.context == null) {
            Object object = this.contextLock;
            synchronized (object) {
                if (this.context == null) {
                    Supplier<C> createdContext = this.createContext(exchange2);
                    this.initialized(createdContext);
                    this.context = createdContext;
                }
            }
        }
        return this.context;
    }

    protected void initialized(Supplier<C> context) {
    }

    private Supplier<C> createContext(ServerWebExchange exchange2) {
        ApplicationContext context = exchange2.getApplicationContext();
        Assert.state(context != null, "No ApplicationContext found on ServerWebExchange.");
        if (this.contextClass.isInstance(context)) {
            return () -> context;
        }
        return () -> context.getBean(this.contextClass);
    }
}

