/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.mongo;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.connection.SslSettings;
import org.bson.UuidRepresentation;
import org.springframework.boot.autoconfigure.mongo.MongoClientSettingsBuilderCustomizer;
import org.springframework.boot.autoconfigure.mongo.MongoConnectionDetails;
import org.springframework.boot.autoconfigure.mongo.MongoProperties;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.core.Ordered;
import org.springframework.util.Assert;

public class StandardMongoClientSettingsBuilderCustomizer
implements MongoClientSettingsBuilderCustomizer,
Ordered {
    private final ConnectionString connectionString;
    private final UuidRepresentation uuidRepresentation;
    private final MongoConnectionDetails connectionDetails;
    private final MongoProperties.Ssl ssl;
    private final SslBundles sslBundles;
    private int order;

    @Deprecated(forRemoval=true, since="3.5.0")
    public StandardMongoClientSettingsBuilderCustomizer(ConnectionString connectionString, UuidRepresentation uuidRepresentation, MongoProperties.Ssl ssl, SslBundles sslBundles) {
        this.connectionDetails = null;
        this.connectionString = connectionString;
        this.uuidRepresentation = uuidRepresentation;
        this.ssl = ssl;
        this.sslBundles = sslBundles;
    }

    public StandardMongoClientSettingsBuilderCustomizer(MongoConnectionDetails connectionDetails, UuidRepresentation uuidRepresentation) {
        this.connectionString = null;
        this.ssl = null;
        this.sslBundles = null;
        this.connectionDetails = connectionDetails;
        this.uuidRepresentation = uuidRepresentation;
    }

    @Override
    public void customize(MongoClientSettings.Builder settingsBuilder) {
        settingsBuilder.uuidRepresentation(this.uuidRepresentation);
        if (this.connectionDetails != null) {
            settingsBuilder.applyConnectionString(this.connectionDetails.getConnectionString());
            settingsBuilder.applyToSslSettings(this::configureSslIfNeeded);
        } else {
            settingsBuilder.uuidRepresentation(this.uuidRepresentation);
            settingsBuilder.applyConnectionString(this.connectionString);
            if (this.ssl.isEnabled()) {
                settingsBuilder.applyToSslSettings(this::configureSsl);
            }
        }
    }

    private void configureSsl(SslSettings.Builder settings) {
        settings.enabled(true);
        if (this.ssl.getBundle() != null) {
            SslBundle sslBundle = this.sslBundles.getBundle(this.ssl.getBundle());
            Assert.state(!sslBundle.getOptions().isSpecified(), "SSL options cannot be specified with MongoDB");
            settings.context(sslBundle.createSslContext());
        }
    }

    private void configureSslIfNeeded(SslSettings.Builder settings) {
        SslBundle sslBundle = this.connectionDetails.getSslBundle();
        if (sslBundle != null) {
            settings.enabled(true);
            Assert.state(!sslBundle.getOptions().isSpecified(), "SSL options cannot be specified with MongoDB");
            settings.context(sslBundle.createSslContext());
        }
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }
}

