/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.internal.shaded.fdp.v2_19_4;

import com.fasterxml.jackson.core.internal.shaded.fdp.v2_19_4.AbstractBigDecimalParser;
import com.fasterxml.jackson.core.internal.shaded.fdp.v2_19_4.FastDoubleSwar;
import com.fasterxml.jackson.core.internal.shaded.fdp.v2_19_4.FastIntegerMath;
import com.fasterxml.jackson.core.internal.shaded.fdp.v2_19_4.FftMultiplier;
import com.fasterxml.jackson.core.internal.shaded.fdp.v2_19_4.ParseDigitsTaskCharArray;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.NavigableMap;

final class JavaBigDecimalFromCharArray
extends AbstractBigDecimalParser {
    public BigDecimal parseBigDecimalString(char[] str, int offset, int length) {
        try {
            int exponentIndicatorIndex;
            long exponent;
            int digitCount;
            boolean isNegative;
            int index2;
            int endIndex = JavaBigDecimalFromCharArray.checkBounds(str.length, offset, length);
            if (JavaBigDecimalFromCharArray.hasManyDigits(length)) {
                return this.parseBigDecimalStringWithManyDigits(str, offset, length);
            }
            long significand = 0L;
            int decimalPointIndex = -1;
            char ch = JavaBigDecimalFromCharArray.charAt(str, index2, endIndex);
            boolean illegal = false;
            boolean bl = isNegative = ch == '-';
            if ((isNegative || ch == '+') && (ch = JavaBigDecimalFromCharArray.charAt(str, ++index2, endIndex)) == '\u0000') {
                throw new NumberFormatException("illegal syntax");
            }
            int integerPartIndex = index2;
            for (index2 = offset; index2 < endIndex; ++index2) {
                int digits;
                ch = str[index2];
                char digit = (char)(ch - 48);
                if (digit < '\n') {
                    significand = 10L * significand + (long)digit;
                    continue;
                }
                if (ch != '.') break;
                illegal |= decimalPointIndex >= 0;
                decimalPointIndex = index2;
                while (index2 < endIndex - 4 && (digits = FastDoubleSwar.tryToParseFourDigits(str, index2 + 1)) >= 0) {
                    significand = 10000L * significand + (long)digits;
                    index2 += 4;
                }
            }
            int significandEndIndex = index2;
            if (decimalPointIndex < 0) {
                digitCount = significandEndIndex - integerPartIndex;
                decimalPointIndex = significandEndIndex;
                exponent = 0L;
            } else {
                digitCount = significandEndIndex - integerPartIndex - 1;
                exponent = decimalPointIndex - significandEndIndex + 1;
            }
            long expNumber = 0L;
            if ((ch | 0x20) == 101) {
                char digit;
                boolean isExponentNegative;
                exponentIndicatorIndex = index2++;
                ch = JavaBigDecimalFromCharArray.charAt(str, index2, endIndex);
                boolean bl2 = isExponentNegative = ch == '-';
                if (isExponentNegative || ch == '+') {
                    ch = JavaBigDecimalFromCharArray.charAt(str, ++index2, endIndex);
                }
                illegal |= (digit = (char)(ch - 48)) >= '\n';
                do {
                    if (expNumber >= Integer.MAX_VALUE) continue;
                    expNumber = 10L * expNumber + (long)digit;
                } while ((digit = (char)((ch = JavaBigDecimalFromCharArray.charAt(str, ++index2, endIndex)) - 48)) < '\n');
                if (isExponentNegative) {
                    expNumber = -expNumber;
                }
                exponent += expNumber;
            } else {
                exponentIndicatorIndex = endIndex;
            }
            JavaBigDecimalFromCharArray.checkParsedBigDecimalBounds(illegal |= digitCount == 0, index2, endIndex, digitCount, exponent);
            if (digitCount < 19) {
                return new BigDecimal(isNegative ? -significand : significand).scaleByPowerOfTen((int)exponent);
            }
            return this.valueOfBigDecimalString(str, integerPartIndex, decimalPointIndex, decimalPointIndex + 1, exponentIndicatorIndex, isNegative, (int)exponent);
        }
        catch (ArithmeticException e) {
            NumberFormatException nfe = new NumberFormatException("value exceeds limits");
            nfe.initCause(e);
            throw nfe;
        }
    }

    BigDecimal parseBigDecimalStringWithManyDigits(char[] str, int offset, int length) {
        int exponentIndicatorIndex;
        long exponent;
        int digitCountWithoutLeadingZeros;
        boolean isNegative;
        int index2;
        int nonZeroFractionalPartIndex = -1;
        int decimalPointIndex = -1;
        int endIndex = offset + length;
        char ch = JavaBigDecimalFromCharArray.charAt(str, index2, endIndex);
        boolean illegal = false;
        boolean bl = isNegative = ch == '-';
        if ((isNegative || ch == '+') && (ch = JavaBigDecimalFromCharArray.charAt(str, ++index2, endIndex)) == '\u0000') {
            throw new NumberFormatException("illegal syntax");
        }
        int integerPartIndex = index2;
        int swarLimit = Math.min(endIndex - 8, 0x40000000);
        for (index2 = offset; index2 < swarLimit && FastDoubleSwar.isEightZeroes(str, index2); index2 += 8) {
        }
        while (index2 < endIndex && str[index2] == '0') {
            ++index2;
        }
        int nonZeroIntegerPartIndex = index2;
        while (index2 < swarLimit && FastDoubleSwar.isEightDigits(str, index2)) {
            index2 += 8;
        }
        while (index2 < endIndex && FastDoubleSwar.isDigit(ch = str[index2])) {
            ++index2;
        }
        if (ch == '.') {
            decimalPointIndex = index2++;
            while (index2 < swarLimit && FastDoubleSwar.isEightZeroes(str, index2)) {
                index2 += 8;
            }
            while (index2 < endIndex && str[index2] == '0') {
                ++index2;
            }
            nonZeroFractionalPartIndex = index2;
            while (index2 < swarLimit && FastDoubleSwar.isEightDigits(str, index2)) {
                index2 += 8;
            }
            while (index2 < endIndex && FastDoubleSwar.isDigit(ch = str[index2])) {
                ++index2;
            }
        }
        int significandEndIndex = index2;
        if (decimalPointIndex < 0) {
            digitCountWithoutLeadingZeros = significandEndIndex - nonZeroIntegerPartIndex;
            decimalPointIndex = significandEndIndex;
            nonZeroFractionalPartIndex = significandEndIndex;
            exponent = 0L;
        } else {
            digitCountWithoutLeadingZeros = nonZeroIntegerPartIndex == decimalPointIndex ? significandEndIndex - nonZeroFractionalPartIndex : significandEndIndex - nonZeroIntegerPartIndex - 1;
            exponent = decimalPointIndex - significandEndIndex + 1;
        }
        long expNumber = 0L;
        if ((ch | 0x20) == 101) {
            char digit;
            boolean isExponentNegative;
            exponentIndicatorIndex = index2++;
            ch = JavaBigDecimalFromCharArray.charAt(str, index2, endIndex);
            boolean bl2 = isExponentNegative = ch == '-';
            if (isExponentNegative || ch == '+') {
                ch = JavaBigDecimalFromCharArray.charAt(str, ++index2, endIndex);
            }
            illegal |= (digit = (char)(ch - 48)) >= '\n';
            do {
                if (expNumber >= Integer.MAX_VALUE) continue;
                expNumber = 10L * expNumber + (long)digit;
            } while ((digit = (char)((ch = JavaBigDecimalFromCharArray.charAt(str, ++index2, endIndex)) - 48)) < '\n');
            if (isExponentNegative) {
                expNumber = -expNumber;
            }
            exponent += expNumber;
        } else {
            exponentIndicatorIndex = endIndex;
        }
        JavaBigDecimalFromCharArray.checkParsedBigDecimalBounds(illegal |= integerPartIndex == decimalPointIndex && decimalPointIndex == exponentIndicatorIndex, index2, endIndex, digitCountWithoutLeadingZeros, exponent);
        return this.valueOfBigDecimalString(str, nonZeroIntegerPartIndex, decimalPointIndex, nonZeroFractionalPartIndex, exponentIndicatorIndex, isNegative, (int)exponent);
    }

    BigDecimal valueOfBigDecimalString(char[] str, int integerPartIndex, int decimalPointIndex, int nonZeroFractionalPartIndex, int exponentIndicatorIndex, boolean isNegative, int exponent) {
        BigInteger significand;
        BigInteger integerPart;
        int fractionDigitsCount = exponentIndicatorIndex - decimalPointIndex - 1;
        int nonZeroFractionDigitsCount = exponentIndicatorIndex - nonZeroFractionalPartIndex;
        int integerDigitsCount = decimalPointIndex - integerPartIndex;
        NavigableMap<Integer, BigInteger> powersOfTen = null;
        if (integerDigitsCount > 0) {
            if (integerDigitsCount > 400) {
                powersOfTen = FastIntegerMath.createPowersOfTenFloor16Map();
                FastIntegerMath.fillPowersOfNFloor16Recursive(powersOfTen, integerPartIndex, decimalPointIndex);
                integerPart = ParseDigitsTaskCharArray.parseDigitsRecursive(str, integerPartIndex, decimalPointIndex, powersOfTen, 400);
            } else {
                integerPart = ParseDigitsTaskCharArray.parseDigitsIterative(str, integerPartIndex, decimalPointIndex);
            }
        } else {
            integerPart = BigInteger.ZERO;
        }
        if (fractionDigitsCount > 0) {
            BigInteger fractionalPart;
            if (nonZeroFractionDigitsCount > 400) {
                if (powersOfTen == null) {
                    powersOfTen = FastIntegerMath.createPowersOfTenFloor16Map();
                }
                FastIntegerMath.fillPowersOfNFloor16Recursive(powersOfTen, nonZeroFractionalPartIndex, exponentIndicatorIndex);
                fractionalPart = ParseDigitsTaskCharArray.parseDigitsRecursive(str, nonZeroFractionalPartIndex, exponentIndicatorIndex, powersOfTen, 400);
            } else {
                fractionalPart = ParseDigitsTaskCharArray.parseDigitsIterative(str, nonZeroFractionalPartIndex, exponentIndicatorIndex);
            }
            if (integerPart.signum() == 0) {
                significand = fractionalPart;
            } else {
                BigInteger integerFactor = FastIntegerMath.computePowerOfTen(powersOfTen, fractionDigitsCount);
                significand = FftMultiplier.multiply(integerPart, integerFactor).add(fractionalPart);
            }
        } else {
            significand = integerPart;
        }
        return new BigDecimal(isNegative ? significand.negate() : significand, -exponent);
    }
}

