/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import org.apache.camel.CamelContext;
import org.apache.camel.NoSuchBeanException;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.ManagedBeanMBean;
import org.apache.camel.component.bean.BeanProcessor;
import org.apache.camel.management.mbean.ManagedProcessor;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.util.ObjectHelper;

@ManagedResource(description="Managed Bean Processor")
public class ManagedBeanProcessor
extends ManagedProcessor
implements ManagedBeanMBean {
    private transient String beanClassName;

    public ManagedBeanProcessor(CamelContext context, BeanProcessor processor, ProcessorDefinition<?> definition) {
        super(context, processor, definition);
    }

    @Override
    public BeanProcessor getProcessor() {
        return (BeanProcessor)super.getProcessor();
    }

    @Override
    public Object getInstance() {
        return this.getProcessor().getBean();
    }

    @Override
    public String getMethod() {
        return this.getProcessor().getMethod();
    }

    @Override
    public String getBeanClassName() {
        if (this.beanClassName != null) {
            return this.beanClassName;
        }
        try {
            Object bean = this.getProcessor().getBean();
            if (bean != null) {
                this.beanClassName = ObjectHelper.className(bean);
            }
        }
        catch (NoSuchBeanException noSuchBeanException) {
            // empty catch block
        }
        return this.beanClassName;
    }
}

